/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.mojang.blaze3d.platform.NativeImage;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.DynamicTextureJson;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.client.util.SafeImageExtraction;
import java.util.function.Supplier;

public class Crop
implements ITexSource {
    public static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    @Override
    public Supplier<NativeImage> getSupplier(String inputStr) throws JsonSyntaxException {
        LocationSource locationSource = (LocationSource)gson.fromJson(inputStr, LocationSource.class);
        Supplier<NativeImage> input = DynamicTextureJson.readSupplierFromSource(locationSource.input);
        return () -> {
            if (input == null) {
                DynamicAssetGenerator.LOGGER.error("Texture given was nonexistent...");
                return null;
            }
            try (NativeImage inImg = (NativeImage)input.get();){
                int scale;
                if (inImg == null) {
                    DynamicAssetGenerator.LOGGER.error("Texture given was nonexistent...\n{}", (Object)locationSource.input.toString());
                    NativeImage nativeImage = null;
                    return nativeImage;
                }
                if (locationSource.total_size == 0) {
                    DynamicAssetGenerator.LOGGER.error("Total image width must be non-zero");
                }
                if ((scale = inImg.m_84982_() / locationSource.total_size) == 0) {
                    DynamicAssetGenerator.LOGGER.error("Image scale turned out to be 0! Image is {} wide, total width is {}", (Object)inImg.m_84982_(), (Object)locationSource.total_size);
                }
                int distX = locationSource.size_x * scale;
                int distY = locationSource.size_y * scale;
                if (distY < 1 || distX < 1) {
                    DynamicAssetGenerator.LOGGER.error("Bounds of image are negative! {}, {}", (Object)locationSource.size_x, (Object)locationSource.size_y);
                    NativeImage nativeImage = null;
                    return nativeImage;
                }
                NativeImage out = NativeImageHelper.of(NativeImage.Format.RGBA, distX, distY, false);
                for (int x = 0; x < distX; ++x) {
                    for (int y = 0; y < distY; ++y) {
                        int c = SafeImageExtraction.get(inImg, x + locationSource.start_x * scale, y + locationSource.start_y * scale);
                        out.m_84988_(x, y, c);
                    }
                }
                NativeImage nativeImage = out;
                return nativeImage;
            }
        };
    }

    public static class LocationSource {
        @Expose
        String source_type;
        @Expose
        int total_size;
        @Expose
        int start_x;
        @Expose
        int size_x;
        @Expose
        int start_y;
        @Expose
        int size_y;
        @Expose
        public JsonObject input;
    }
}

